#============================================================================== 
# ** Ruby.Integer
#------------------------------------------------------------------------------
# Description:
# ------------
# Miscellaneous New stuff for the Integer class.
#  
# Method List:
# ------------
# factorial
# primorial
# multifactorial
#==============================================================================

MACL::Loaded << 'Ruby.Integer'

#============================================================================== 
# ** Integer     
#==============================================================================

class Integer     
  #-------------------------------------------------------------------------
  #   Name      : Factorial
  #   Info      : Return the factorial of number
  #   Author    : Tibuda
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def factorial
    result = 1
    self.downto(2) {|i| result *= i }
    return result
  end            
  #-------------------------------------------------------------------------
  #   Name      : Primorial
  #   Info      : Return the primorial of number
  #   Author    : Tibuda
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def primorial
    result = 1
    self.downto(2) {|i| result *= i if i.is_prime? }
    return result
  end      
  #-------------------------------------------------------------------------
  #   Name      : Multifactorial
  #   Info      : Return the multifactorial of number
  #   Author    : Tibuda
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------  
  def multifactorial(n = 2)
    result = self
    n.downto(1) {|i| result = result.factorial } 
    return result
  end
end